---
Difficulty: Hard  
Source: Daily-Question (POTD 28-Nov)  
tags:
    - Breadth-First Search
    - Graph
    - Array
    - Matrix
    - Shortest Path
    - Heap (Priority Queue)
---

# 🚀 *2290 - Minimum Obstacle Removal to Reach Corner* 🧠

### Problem Link:  
[**LeetCode - Minimum Obstacle Removal to Reach Corner**](https://leetcode.com/problems/minimum-obstacle-removal-to-reach-corner/?envType=daily-question&envId=2024-11-28)

## 💡 **Problem Breakdown:**

You are given a 0-indexed 2D integer array `grid` of size `m x n`. Each cell has one of two values:
- `0` represents an empty cell.
- `1` represents an obstacle that may be removed.

You can move up, down, left, or right from and to an empty cell.  
The goal is to find the minimum number of obstacles to remove so you can move from the upper left corner `(0, 0)` to the lower right corner `(m - 1, n - 1)`.

## 🔍 **Example Walkthrough:**

### Example 1:
<img src="https://github.com/user-attachments/assets/bb70995a-242b-41a1-b234-95f4abe65be1" width="48%">

**Input:**  
`grid = [[0,1,1],[1,1,0],[1,1,0]]`  
**Output:**  
`2`  

**Explanation:**  
We can remove the obstacles at `(0, 1)` and `(0, 2)` to create a path from `(0, 0)` to `(2, 2)`.  
It can be shown that we need to remove at least 2 obstacles, so we return `2`.

### Example 2:
<img src="https://github.com/user-attachments/assets/8e917142-30b6-41a4-bc95-65a49bf2e44d" width="38%">

**Input:**  
`grid = [[0,1,0,0,0],[0,1,0,1,0],[0,0,0,1,0]]`  
**Output:**  
`0`  

**Explanation:**  
We can move from `(0, 0)` to `(2, 4)` without removing any obstacles, so we return `0`.

### Constraints:
- `m == grid.length`
- `n == grid[i].length`
- $`1 <= m, n <= 10^5`$
- $`2 <= m * n <= 10^5`$
- `grid[i][j]` is either `0` or `1`.
- `grid[0][0] == grid[m - 1][n - 1] == 0`

## 🎯 **My Approach:**

1. **Breadth-First Search (BFS):**  
   - Use BFS to explore the grid while keeping track of the number of obstacles removed. BFS is suitable here because it finds the shortest path in an unweighted grid.
  
2. **Two-Queue Mechanism:**  
   - A deque is used to simulate two types of movement:  
     - Cells without obstacles are added to the front of the deque.  
     - Cells with obstacles are added to the back of the deque. This allows cells with fewer obstacles to be processed first.

3. **Implementation Steps:**  
   - Initialize the distance array with a very large value (`inf`).
   - Use a deque to store positions, prioritizing cells without obstacles.
   - For each cell, explore all 4 directions (up, down, left, right) and update the distances as needed.
   - Return the number of obstacles to remove when reaching the destination `(m - 1, n - 1)`.

## 🕒 **Time Complexity:**
- **O(m × n):**  
  - BFS processes each cell once, and each operation (insertion or removal from the deque) takes constant time.
  
- **Space Complexity:**  
  - **O(m × n):**  
    - We store the grid, distance array, and the deque, each of size `m × n`.

## 📝 **Solution Code**

## Code (C)

```c
#define MAX_QUEUE 1000000

typedef struct {
    int x, y;
} Point;

int minimumObstacles(int** grid, int gridSize, int* gridColSize) {
    int m = gridSize, n = gridColSize[0];
    int dist[m][n];
    memset(dist, 0x3f, sizeof(dist)); 
    dist[0][0] = 0;

    Point queue[MAX_QUEUE];
    int front = MAX_QUEUE / 2, back = MAX_QUEUE / 2; 
    queue[back++] = (Point){0, 0};

    int dirs[4][2] = {{-1, 0}, {1, 0}, {0, -1}, {0, 1}};

    while (front < back) {
        Point current = queue[front++];
        int cur_dist = dist[current.x][current.y];

        for (int i = 0; i < 4; i++) {
            int nx = current.x + dirs[i][0];
            int ny = current.y + dirs[i][1];

            if (nx >= 0 && nx < m && ny >= 0 && ny < n) {
                int new_dist = cur_dist + grid[nx][ny];
                if (new_dist < dist[nx][ny]) {
                    dist[nx][ny] = new_dist;
                    if (grid[nx][ny] == 1) {
                        queue[back++] = (Point){nx, ny}; 
                    } else {
                        queue[--front] = (Point){nx, ny};
                    }
                }
            }
        }
    }

    return dist[m - 1][n - 1];
}
```

## Code (C++)

```cpp
class Solution {
public:
    int minimumObstacles(vector<vector<int>>& grid) {
        int m = grid.size(), n = grid[0].size();
        vector<vector<int>> dist(m, vector<int>(n, INT_MAX));
        dist[0][0] = 0;
        
        deque<pair<int, int>> q;
        q.push_back({0, 0});
        
        vector<pair<int, int>> dirs = {{-1, 0}, {1, 0}, {0, -1}, {0, 1}};
        
        while (!q.empty()) {
            auto [i, j] = q.front();
            q.pop_front();
            int cur_dist = dist[i][j];
            
            if (i == m - 1 && j == n - 1) {
                return cur_dist;
            }
            
            for (auto& [dx, dy] : dirs) {
                int x = i + dx, y = j + dy;
                if (x >= 0 && x < m && y >= 0 && y < n) {
                    int new_dist = cur_dist + grid[x][y];
                    if (new_dist < dist[x][y]) {
                        dist[x][y] = new_dist;
                        if (grid[x][y] == 1) {
                            q.push_back({x, y});
                        } else {
                            q.push_front({x, y});
                        }
                    }
                }
            }
        }
        
        return dist[m - 1][n - 1] != INT_MAX ? dist[m - 1][n - 1] : -1;
    }
};
```

## Code (Java)

```java
class Solution {
    public int minimumObstacles(int[][] grid) {
        int m = grid.length, n = grid[0].length;
        int[][] dist = new int[m][n];
        for (int[] row : dist) {
            Arrays.fill(row, Integer.MAX_VALUE);
        }
        dist[0][0] = 0;
        
        Deque<int[]> q = new ArrayDeque<>();
        q.offer(new int[]{0, 0});
        
        int[][] dirs = {{-1, 0}, {1, 0}, {0, -1}, {0, 1}};
        
        while (!q.isEmpty()) {
            int[] cell = q.poll();
            int i = cell[0], j = cell[1];
            int curDist = dist[i][j];
            
            if (i == m - 1 && j == n - 1) {
                return curDist;
            }
            
            for (int[] dir : dirs) {
                int x = i + dir[0], y = j + dir[1];
                if (x >= 0 && x < m && y >= 0 && y < n) {
                    int newDist = curDist + grid[x][y];
                    if (newDist < dist[x][y]) {
                        dist[x][y] = newDist;
                        if (grid[x][y] == 1) {
                            q.offer(new int[]{x, y});
                        } else {
                            q.offerFirst(new int[]{x, y});
                        }
                    }
                }
            }
        }
        
        return dist[m - 1][n - 1] != Integer.MAX_VALUE ? dist[m - 1][n - 1] : -1;
    }
}
```

## Code (Python)

```python3
from collections import deque
from typing import List

class Solution:
    def minimumObstacles(self, grid: List[List[int]]) -> int:
        m, n = len(grid), len(grid[0])
        dist = [[float('inf')] * n for _ in range(m)]
        dist[0][0] = 0
        
        q = deque([(0, 0)])
        
        dirs = [(-1, 0), (1, 0), (0, -1), (0, 1)]
        
        while q:
            i, j = q.popleft()
            cur_dist = dist[i][j]
            
            if i == m - 1 and j == n - 1:
                return cur_dist
            
            for dx, dy in dirs:
                x, y = i + dx, j + dy
                if 0 <= x < m and 0 <= y < n:
                    new_dist = cur_dist + grid[x][y]
                    if new_dist < dist[x][y]:
                        dist[x][y] = new_dist
                        if grid[x][y] == 1:
                            q.append((x, y)) 
                        else:
                            q.appendleft((x, y))  
        
        return dist[m - 1][n - 1] if dist[m - 1][n - 1] != float('inf') else -1
```
## Code (Rust)

```rust
use std::collections::VecDeque;
impl Solution {
    pub fn minimum_obstacles(grid: Vec<Vec<i32>>) -> i32 {
        let m = grid.len();
        let n = grid[0].len();
        let mut dist = vec![vec![i32::MAX; n]; m];
        dist[0][0] = 0;
        let mut q = VecDeque::new();
        q.push_back((0, 0)); 
        let dirs = [(0, 1), (1, 0), (0, -1), (-1, 0)];
        while let Some((i, j)) = q.pop_front() {
            let cur_dist = dist[i][j];
            if i == m - 1 && j == n - 1 {
                return cur_dist;
            }
            for &(dx, dy) in &dirs {
                let x = i as i32 + dx;
                let y = j as i32 + dy;
                if x >= 0 && x < m as i32 && y >= 0 && y < n as i32 {
                    let x = x as usize;
                    let y = y as usize;
                    let new_dist = cur_dist + grid[x][y];
                    if new_dist < dist[x][y] {
                        dist[x][y] = new_dist;
                        if grid[x][y] == 1 {
                            q.push_back((x, y)); 
                        } else {
                            q.push_front((x, y)); 
                        }
                    }
                }
            }
        }
        if dist[m - 1][n - 1] == i32::MAX {
            -1
        } else {
            dist[m - 1][n - 1]
        }
    }
}
```

# 🎯 **Contribute or Ask Questions:**
For more discussions, questions, or help with the solution, feel free to reach out on LinkedIn: [**Connect with Me!**](https://www.linkedin.com/in/het-patel-8b110525a/).

## <img src="https://github.com/user-attachments/assets/35f6838c-52f5-4e48-8a98-c5203f8c57e3" style="width:29px; color: #FFD700" alt="Star GIF"> **Enjoying the Solution?**  
If this helped you, please **star this repo** to support the efforts and keep it growing!
